/**************************************************************************//**
 * @file        uart_stdio.h
 * @version     V1.00.00
 * $Revision:   0 $
 * $Date:       2020-11-13 $
 * @brief       The Header file for uart_stdout.c
 *
 * @note
 *
 * Copyright (C) 2020 AMICCOM Electronics Corp. All rights reserved.
 ******************************************************************************/

#ifndef _UART_STDOUT_H_
#define _UART_STDOUT_H_

#include "system_A9139M0.h"

extern UART_Type* UartStdio;

/**
 * @brief   Initial uart TX and set set IO altfuncset
 */
extern void UartStdOutInit ( UART_Type *uart, Uint32 baudrate );


/**
 * @brief   Initial uart RX and set set IO altfuncset
 */
extern void UartStdInInit ( UART_Type *uart, Uint32 baudrate );

/**
 * @brief   Initial uart RX/TX and set set IO altfuncset
 */
extern void UartStdInOutInit ( UART_Type *uart, Uint32 baudrate );

/**
 * @brief   UartPutc for retarget.c
 */
extern unsigned char UartPutc ( unsigned char my_ch );

/**
 * @brief   UartGetc for retarget.c
 */
extern unsigned char UartGetc ( void );

/**
 * @brief   UartEndSimulation for retarget.c
 */
extern unsigned char UartEndSimulation(void);

#endif
